import java.util.InputMismatchException;
import java.util.Scanner;

class CustomException extends Exception {

	public CustomException(String string) {
		super(string);
	}

}

final class UtilsMatrix {

	public static int[][] multiply(int[][] mat1, int[][] mat2) throws CustomException {

		checkMatrix(mat1);
		checkMatrix(mat2);

		int rows1 = mat1.length;
		int cols1 = mat1[0].length;
		int rows2 = mat2.length;
		int cols2 = mat2[0].length;		

		if (cols1 != rows2) {
			throw new CustomException("Matrix dimensions must fits");
		}

		int[][] result = new int[rows1][cols2];
		for (int i = 0; i < rows1; i++) {
			for (int j = 0; j < cols2; j++) {
				for (int k = 0; k < rows2; k++) {
					result[i][j] += mat1[i][k] * mat2[k][j];
				}
			}
		}
		return result;
	}
	
	private static int tryReadInt(Scanner scanner) throws CustomException {
		int val = -1;
		try {
			val = scanner.nextInt();
		} catch (InputMismatchException e) {
			throw new CustomException("Vous devez entrez un nombre");
		}
		if (val <= 0) {
			throw new CustomException("Vous devez entrez des valeurs strictement positives !");
		}
		return val;
		
	}

	public static int[][] readMatrix() throws CustomException {
		Scanner scanner = new Scanner(System.in);
		
		int row = -1;
		int col = -1;

		System.out.println("Nouvelle matrice");
		
		System.out.print("\t Entrez nombre de lignes : ");
		row = tryReadInt(scanner);
		System.out.print("\t Entrez nombre de colonnes : ");

		col = tryReadInt(scanner);
		
		int[][] result = new int[row][col];
		for (int i = 0; i < row; i++) {
			for (int j = 0; j < col; j++) {
				System.out.print("\t Contenu cellule [" + i + "][" + j + "] : ");
				try {
					result[i][j] = scanner.nextInt();
				} catch (InputMismatchException e) {
					throw new CustomException("Vous devez entrez un nombre");
				}
			}
		}
		return result;
	}

	/**
	 * Ensure that the matrix is not null nor empty and in the right format
	 * @param mat
	 * @throws CustomException
	 */
	public static void checkMatrix(int[][] mat) throws CustomException {
		if (mat == null) {
			throw new CustomException("Matrix should be initialized");
		}
		if (mat.length == 0) {
			throw new CustomException("Matrix should not be empty");
		}
		int lineLength = mat[0].length;
		for (int[] lines : mat) {
			if (lineLength != lines.length){
				throw new CustomException("This is clearly not a matrix !");
			} 
		}
	}
	
	public static void display(int[][] mat) {
		for (int[] lines : mat) {
			for (int item : lines) {
				System.out.print(item + " ");
			}
			System.out.println();
		}
	}

	public static void main(String[] args) {
		int[][] mat1 = null;
		int[][] mat2 = null;
		boolean dataOk = true;
		do {
			try {
				dataOk = true;
				mat1 = readMatrix();
				mat2 = readMatrix();
			} catch (CustomException e) {
				System.err.println(e.getMessage());
				dataOk = false;
			}
		} while (!dataOk);

		int[][] prod = null;
		try {
			prod = multiply(mat1, mat2);
			display(prod);
		} catch (CustomException e) {
			System.err.println(e.getMessage());
		}
	}
}
